<?php
/**
 * Default Page
 *
 * @since    1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<div class="tipi-block tipi-welcome">

	<div class="tipi-box tipi-xs-12 tipi-m-6 tipi-col tipi-col-first">
		<img src="<?php echo esc_url( plugin_dir_url( __DIR__ ) . 'images/welcome.png' ); ?>" alt="">
	</div>
	<div class="tipi-box tipi-xs-12 tipi-m-6 tipi-col tipi-col-last tipi-changelog">
		<div class="tipi-content-area">
			<div class="tipi-title-with-i lr-cf">
				<span class="tipi-title-i"><i class="tipi-icon tipi-i-lets-review"></i></span>
				<div class="tipi-title">
					<h3><?php esc_html_e( 'Changelog', 'lets-review' ); ?></h3>
				</div>
			</div>
			<div class="tipi-content">
				<h4>Version 3.4.3</h4>
				<ul>
					<li><span class="added"></span><p>WordPress 6.4.2 compatibility</p></li>
					<li><span class="added"></span><p>PHP 8.2 compatibility</p></li>
					<li><span class="added"></span><p>PHP 8.3 compatibility</p></li>
				</ul>
				<h4>Version 3.4.2</h4>
				<ul>
					<li><span class="bugfix"></span><p>Comment User Reviews: Leaving zero as a score was not applying</p></li>
					<li><span class="improved"></span><p>Compatibility with more themes.</p></li>
				</ul>
				<h4>Version 3.4.1</h4>
				<ul>
					<li><span class="improved"></span><p>Schema Updated: Brand field uses latest requirement structure</p></li>
					<li><span class="bugfix"></span><p>Posts set to Visitor Comment Reviews type: Affiliate block was not showing in summary block</p></li>
					<li><span class="bugfix"></span><p>Let's Review Widget: Score Type set to Comment Review Scroes type: Not all posts showing</p></li>
					<li><span class="bugfix"></span><p>User comments with reviews weren't showing scores</p></li>
					<li><span class="bugfix"></span><p>Backend Final Score Calculation wasn't working as expected</p></li>
				</ul>
				<h4>Version 3.4.0</h4>
				<ul>
					<li><span class="improved"></span><p>Posts > All Posts: Review posts are now marked as such here</p></li>
					<li><span class="bugfix"></span><p>Backend Final Score Calculation wasn't working as expected</p></li>
				</ul>
				<h4>Version 3.3.9.1</h4>
				<ul>
					<li><span class="improved"></span><p>Latest Gutenberg compatibility</p></li>
				</ul>
				<h4>Version 3.3.9</h4>
				<ul>
					<li><span class="bugfix"></span><p>Top Half Width Review box wasn't outputting schema</p></li>
					<li><span class="bugfix"></span><p>Styling quirks</p></li>
				</ul>
				<h4>Version 3.3.8</h4>
				<ul>
					<li><span class="bugfix"></span><p>Let's Review backend: Final score when Percentage option set, wasn't calculated properly</p></li>
					<li><span class="bugfix"></span><p>Minimal Review design image wasn't circle on some themes</p></li>
				</ul>
				<h4>Version 3.3.7</h4>
				<ul>
					<li><span class="improved"></span><p>FontAwesome not loading outside of post</p></li>
				</ul>
				<h4>Version 3.3.6</h4>
				<ul>
					<li><span class="improved"></span><p>Plugin CSS filesize: 15% reduction</p></li>
				</ul>
				<h4>Version 3.3.5</h4>
				<ul>
					<li><span class="bugfix"></span><p>Review data outputting on Password Protected posts before password was entered</p></li>
					<li><span class="bugfix"></span><p>Scores not appearing in the backend</p></li>
				</ul>
				<h4>Version 3.3.4</h4>
				<ul>
					<li><span class="bugfix"></span><p>Minor quirk with user ratings calculations</p></li>
				</ul>
				<h4>Version 3.3.3</h4>
				<ul>
					<li><span class="bugfix"></span><p>Let's Review Gutenberg Blocks > Visitor Comment Review Averages: Warning message</p></li>
					<li><span class="bugfix"></span><p>Lightbox styling issue</p></li>
				</ul>
				<h4>Version 3.3.2</h4>
				<ul>
					<li><span class="improved"></span><p>Added extra HTML class to API score boxes if subtitle enabled</p></li>
				</ul>
				<h4>Version 3.3.1</h4>
				<ul>
					<li><span class="improved"></span><p>Custom Icon Code option now accepts SVG code</p></li>
				</ul>
				<h4>Version 3.3.0</h4>
				<ul>
					<li><span class="added"></span><p>Option to disable plugin schema from outputting</p></li>
					<li><span class="improved"></span><p>Lightbox replaced with sleek new highly touch-friendly lightbox (Shows captions too)</p></li>
					<li><span class="bugfix"></span><p>User Rating: Hovering over wouldn't trigger granular score class change (Only applies to some designs)</p></li>
				</ul>
				<h4>Version 3.2.9</h4>
				<ul>
					<li><span class="improved"></span><p>Styling details</p></li>
				</ul>
				<h4>Version 3.2.8</h4>
				<ul>
					<li><span class="added"></span><p>Compatibility with WordPress 5.6</p></li>
					<li><span class="bugfix"></span><p>Normal comments thumbs up/down option not working properly</p></li>
				</ul>
				<h4>Version 3.2.7</h4>
				<ul>
					<li><span class="added"></span><p>Filter to change default scores in new user comment reviews forms</p></li>
				</ul>
				<h4>Version 3.2.6</h4>
				<ul>
					<li><span class="improved"></span><p>Let's Review Gutenberg Block: Compatible with latest Gutenberg changes</p></li>
				</ul>
				<h4>Version 3.2.5</h4>
				<ul>
					<li><span class="added"></span><p>Widget: Sort by Comment Review Average Final Score option</p></li>
				</ul>
				<h4>Version 3.2.4</h4>
				<ul>
					<li><span class="bugfix"></span><p>Shortcodes styling wasn't loading</p></li>
				</ul>
				<h4>Version 3.2.3</h4>
				<ul>
					<li><span class="bugfix"></span><p>Fixed notices in WordPress 5.5</p></li>
				</ul>
				<h4>Version 3.2.2</h4>
				<ul>
					<li><span class="improved"></span><p>Styling improvements</p></li>
				</ul>
				<h4>Version 3.2.1</h4>
				<ul>
					<li><span class="improved"></span><p>Compatibility with Picture elements (for webp images)</p></li>
					<li><span class="bugfix"></span><p>List shortcode: If entering specific post ids, number of reviews shown was being overwritten by WordPress posts per page option</p></li>
					<li><span class="bugfix"></span><p>Removed Aqua Resizer (Caused errors on some servers) and replaced with native functions.</p></li>
				</ul>
				<h4>Version 3.2.0</h4>
				<ul>
					<li><span class="added"></span><p>New standard Review Type option: Visitor Comment Reviews (Big thanks to Stefan for funding the development of this feature)</p></li>
					<li><span class="added"></span><p>New shortcode to get visitor comment review average final score: [letsreviewcommentaveragefinalscore postid=123] (Big thanks to Stefan for funding the development of this feature)</p></li>
					<li><span class="added"></span><p>WPML: Full compatibility</p></li>
					<li><span class="improved"></span><p>Better performance: Assets file size reduced</p></li>
					<li><span class="bugfix"></span><p>API returning Incorrect user rating score outside of post</p></li>
					<li><span class="bugfix"></span><p>Who Can Leave User Rating: Logged in users only - wasn't applying properly</p></li>
					<li><span class="bugfix"></span><p>Minimalist B option was hiding Skin/Animation options</p></li>
					<li><span class="bugfix"></span><p>Some default options not applied to posts that were auto-created</p></li>
				</ul>
				<h4>Version 3.1.7</h4>
				<ul>
					<li><span class="added"></span><p>Let's Review > Options: Up Down Votes in Normal Comments</p></li>
					<li><span class="improved"></span><p>Readme.txt file now shows correct version</p></li>
					<li><span class="bugfix"></span><p>Comment reviews were including reviews even if the visitor set it to "off"</p></li>
				</ul>
				<h4>Version 3.1.6</h4>
				<ul>
					<li><span class="added"></span><p>New shortcode for: Let's Review Gutenberg Comments Average block - [letsreviewcommentaverage postid="123" skin="2" design="6" accent="#f8d92f" title="Average scores from users"]</p></li>
					<li><span class="improved"></span><p>Styling improvements</p></li>
					<li><span class="bugfix"></span><p>Default options section criteria styling</p></li>
				</ul>
				<h4>Version 3.1.5</h4>
				<ul>
					<li><span class="added"></span><p>New review migration option: Extra Theme/Divi Reviews (Elegant Themes)</p></li>
				</ul>
				<h4>Version 3.1.4</h4>
				<ul>
					<li><span class="bugfix"></span><p>If comment reviews enabled by default, criterias weren't visible</p></li>
				</ul>
				<h4>Version 3.1.3</h4>
				<ul>
					<li><span class="bugfix"></span><p>If custom header font set and no custom body one, it affected review body too</p></li>
					<li><span class="bugfix"></span><p>Multiple categories not showing in list shortcode</p></li>
				</ul>
				<h4>Version 3.1.1</h4>
				<ul>
					<li><span class="improved"></span><p>Comment User Reviews are now slideable on mobile</p></li>
					<li><span class="improved"></span><p>Let's Review Widget: Tags/Posts filter option now turned into input for better performance</p></li>
					<li><span class="bugfix"></span><p>User Rating Shortcode was always showing percentage format</p></li>
				</ul>
				<h4>Version 3.0.9</h4>
				<ul>
					<li><span class="bugfix"></span><p>Reader Rating not appearing in "Editor + visitor" review type if no criterias set</p></li>
					<li><span class="bugfix"></span><p>Review title not appearing on some designs</p></li>
				</ul>
				<h4>Version 3.0.8</h4>
				<ul>
					<li><span class="bugfix"></span><p>Some minor quirks</p></li>
				</ul>
				<h4>Version 3.0.7</h4>
				<ul>
					<li><span class="improved"></span><p>Lists: Post images in lists now link to review directly</p></li>
					<li><span class="added"></span><p>New option in Let's Review Gutenberg Comment Review Average block: Score type (points/percentage)</p></li>
				</ul>
				<h4>Version 3.0.6</h4>
				<ul>
					<li><span class="added"></span><p>New filter to change review main title html element (see docs)</p></li>
					<li><span class="added"></span><p>Minimalist B design to global default option</p></li>
					<li><span class="improved"></span><p>Various styling details</p></li>
					<li><span class="updated"></span><p>Translation files</p></li>
					<li><span class="bugfix"></span><p>API external score when set to visitor only and points</p></li>
					<li><span class="bugfix"></span><p>Top Half-width Location wasn't showing all data</p></li>
					<li><span class="bugfix"></span><p>Let's Review Options: Reader Rating Title wasn't overwriting the default title</p></li>
				</ul>
				<h4>Version 3.0.5</h4>
				<ul>
					<li><span class="improved"></span><p>Conclusion now accepts common html elements (ul/ol/strong/a/etc)</p></li>
					<li><span class="bugfix"></span><p>Lists weren't using custom review title</p></li>
				</ul>
				<h4>Version 3.0.4</h4>
				<ul>
					<li><span class="added"></span><p>New tab in metabox options: Schema</p></li>
					<li><span class="added"></span><p>Movie Schema</p></li>
					<li><span class="added"></span><p>Multiple required schema property options</p></li>
					<li><span class="updated"></span><p>Schema to very latest requirements (They change them... a lot)</p></li>
					<li><span class="updated"></span><p>Removed Music Playlist and Recording schemas, caused by new Google requirements</p></li>
					<li><span class="updated"></span><p>Shortcode tool interface layout tweaks</p></li>
					<li><span class="bugfix"></span><p>Global Schema On/Off switch wasn't working</p></li>
					<li><span class="bugfix"></span><p>Visitor Review only review schema not outputting</p></li>
				</ul>
				<h4>Version 3.0.3</h4>
				<ul>
					<li><span class="added"></span><p>Various filters/hooks for developers wanted to inject custom data in various locations of a review</p></li>
					<li><span class="added"></span><p>Animations and Light skin for new Minimalist B design</p></li>
					<li><span class="improved"></span><p>Styling details</p></li>
					<li><span class="improved"></span><p>Documentation: How to change visitor rating scores</p></li>
					<li><span class="bugfix"></span><p>Classic Editor: Overlapping options in backend when classic editor used</p></li>
					<li><span class="bugfix"></span><p>Gutenberg Review Block left half position wasn't applying</p></li>
					<li><span class="bugfix"></span><p>User rating only metabox type reviews with final score showing editor score</p></li>
					<li><span class="bugfix"></span><p>Custom image option wasn't applying to metabox type reviews</p></li>
					<li><span class="bugfix"></span><p>Minimalist B design (new one) icons</p></li>
					<li><span class="bugfix"></span><p>Final score box not showing icons/image</p></li>
				</ul>
				<h4>Version 3.0.2</h4>
				<ul>
					<li><span class="bugfix"></span><p>Affiliate links weren't opening in new tabs</p></li>
					<li><span class="bugfix"></span><p>Top half width option was full width</p></li>
					<li><span class="bugfix"></span><p>Custom shopping cart icon override quirk</p></li>
				</ul>
				<h4>Version 3.0.1</h4>
				<ul>
					<li><span class="improved"></span><p>Styling compatibility</p></li>
					<li><span class="bugfix"></span><p>Users using Valenti/15Zine had big scores</p></li>
					<li><span class="bugfix"></span><p>Minor quirk with non-numeric values</p></li>
				</ul>
				<h4>Version 3.0.0</h4>
				<ul>
					<li><span class="added"></span><p>Let's Review > Options: JSON-LD Review Schema (on/off)</p></li>
					<li><span class="added"></span><p>Reviews can select the type of Schema type</p></li>
					<li><span class="added"></span><p>AMP compatibility for main AMP plugins</p></li>
					<li><span class="added"></span><p>Design: Minimalist B</p></li>
					<li><span class="added"></span><p>Gutenberg Let's Review Block: Review Block</p></li>
					<li><span class="added"></span><p>Gutenberg Let's Review Block: Average Visitor Comment Scores Block</p></li>
					<li><span class="added"></span><p>Gutenberg Let's Review Block: User Rating Block</p></li>
					<li><span class="added"></span><p>New filter to increase number of stars/icons/images (see documentation)</p></li>
					<li><span class="added"></span><p>Thumbs Up/Down (helpful/not helpful) voting system for comment reviews</p></li>
					<li><span class="improved"></span><p>Custom Icons option can now use HTML or SVG icons</p></li>
					<li><span class="improved"></span><p>Updated Font Awesome to V5 - icon html code has changed, check FontAwesome website for new code</p></li>
					<li><span class="improved"></span><p>Visitors can now edit their user ratings</p></li>
					<li><span class="improved"></span><p>User Comment Reviews on mobile can input exact scores manually</p></li>
					<li><span class="improved"></span><p>Pros/Cons now accept HTML such as <3</p></li>
					<li><span class="improved"></span><p>Separated dependencies for improved performance</p></li>
					<li><span class="improved"></span><p>Gallery Images now output Alt tag</p></li>
					<li><span class="improved"></span><p>Comment reviews now only visible on main comments (not replies to other comments)</p></li>
					<li><span class="improved"></span><p>Lots of details</p></li>
					<li><span class="improved"></span><p>General styling</p></li>
					<li><span class="improved"></span><p>Updated schema to JSON-LD</p></li>
					<li><span class="improved"></span><p>Performance</p></li>
					<li><span class="improved"></span><p>Documentation</p></li>
					<li><span class="improved"></span><p>Framework rewrite and modernisation</p></li>
					<li><span class="bugfix"></span><p>Various quirks fixed</p></li>
				</ul>
				<h4>Version 2.1.1</h4>
				<ul>
					<li><span class="added"></span><p>Dutch Translation - Thanks TerrorJunk :)</p></li>
				</ul>
				<h4>Version 2.1</h4>
				<ul>
					<li><span class="added"></span><p>Option for reviews to use the Featured Image as Main review image</p></li>
					<li><span class="added"></span><p>Swedish Translation - Thanks Daniel :)</p></li>
					<li><span class="added"></span><p>Extra css to stop some themes from imposing bad styling on reviews</p></li>
					<li><span class="improved"></span><p>Affiliate button styling for very long buttons</p></li>
					<li><span class="improved"></span><p>Affiliate button styling on mobile</p></li>
					<li><span class="improved"></span><p>Mobile Design 2 styling</p></li>
					<li><span class="improved"></span><p>Mobile Design 1 styling</p></li>
					<li><span class="bugfix"></span><p>Show review outside post option on categories</p></li>
				</ul>
				<h4>Version 2.0.1</h4>
				<ul>
					<li><span class="added"></span><p>Option in Let's Review -> Options: Default value of "Is this a review" field in the comment form.</p></li>
					<li><span class="bugfix"></span><p>Visitor reviews weren't showing custom icons</p></li>
					<li><span class="bugfix"></span><p>Visitor reviews form didn't show final score slider option if no criterias set</p></li>
					<li><span class="bugfix"></span><p>Missing translations</p></li>
					<li><span class="bugfix"></span><p>User rating box calculation in custom icons</p></li>
				</ul>
				<h4>Version 2.0.0</h4>
				<ul>
					<li><span class="added"></span><p>User Reviews - Site visitors can leave reviews via comments.</p></li>
					<li><span class="added"></span><p>Shortcode interface tool: "Insert Lets Review Shortcode" option in post editing toolbar.</p></li>
					<li><span class="added"></span><p>Shortcode: Unique review. Create a one-off review anywhere.</p></li>
					<li><span class="added"></span><p>Shortcode: Visitor Rating Box. Add as many as you wish.</p></li>
					<li><span class="added"></span><p>Review migration tool in Let's Review -> Migration</p></li>
					<li><span class="added"></span><p>Design Option: Clean</p></li>
					<li><span class="added"></span><p>Design Option: Modern B</p></li>
					<li><span class="added"></span><p>Option for Comparison List Shortcode: Source (Select from specific posts/categories/tags)</p></li>
					<li><span class="added"></span><p>Option for Comparison List shortcode: Order (Manual/Latest Published/Top scores)</p></li>
					<li><span class="added"></span><p>Option for Comparison List shortcode: Number of posts (When "Source" is set to categories/tags)</p></li>
					<li><span class="added"></span><p>Option to enter any custom html/icon code for the affiliate shopping cart icon</p></li>
					<li><span class="added"></span><p>Option to add custom class to images. Useful if you use your own lightbox that targets a certain class.</p></li>
					<li><span class="added"></span><p>Option to automatically use post title as review title</p></li>
					<li><span class="added"></span><p>Option in Let's Review -> Options: Who can leave user rating (Everyone / Only logged in users)</p></li>
					<li><span class="added"></span><p>Option in Let's Review -> Options: Visitor rating title (To change the "Reader Rating" title text)</p></li>
					<li><span class="added"></span><p>Option in Let's Review -> Options: Always show final score number in final score boxes (show it above stars/icons/images)</p></li>
					<li><span class="added"></span><p>Option in Let's Review -> Extras: Show Full Review Boxes outside post.</p></li>
					<li><span class="added"></span><p>Option in Let's Review Widget: Show reviews from tag(s)</p></li>
					<li><span class="added"></span><p>Option in Let's Review Widget: Manually select specific posts to show (includes pages/custom posts too)</p></li>
					<li><span class="added"></span><p>Lots of new options in Let's Review -> Default Values</p></li>
					<li><span class="added"></span><p>API option to easily get a score box that is full HTML ready (use inside loop) - Lets_Review_API::lets_review_get_score_box( $post->id );</p></li>
					<li><span class="added"></span><p>Filter (on/off) to make stars/icons/image final score be able to show 2 decimals for quarters, example: 4.25</p></li>
					<li><span class="added"></span><p>Danish translation (Thanks to Michelle)</p></li>
					<li><span class="improved"></span><p>List shortcode title's now also link to relevant review</p></li>
					<li><span class="improved"></span><p>Let's review Widget can now use custom post types too</p></li>
					<li><span class="improved"></span><p>Star reviews now also show stars in score box outside of post</p></li>
					<li><span class="improved"></span><p>Added widget option to enter the background color of your theme's sidebar area (For "Simple with stars" design option)</p></li>
					<li><span class="improved"></span><p>Backend colorpicker switched to WordPress standard color picker</p></li>
					<li><span class="improved"></span><p>Backend UI completely revamped</p></li>
					<li><span class="improved"></span><p>Code spring cleaning</p></li>
					<li><span class="updated"></span><p>Documentation redesign and update</p></li>
					<li><span class="updated"></span><p>FontAwesome icons to 4.7 (41 new icons)</p></li>
					<li><span class="bugfix"></span><p>Let's Review widget user rating score miscalculation</p></li>
					<li><span class="bugfix"></span><p>User rating aggregate schema missing meta</p></li>
				</ul>
			</div>
		</div>
	</div>

</div>
